<?php

function createImageFromURL($url) {
    // Kontrol et, URL geçerli mi
    if (@getimagesize($url) === false) {
        return false;
    }

    $imageInfo = getimagesize($url);
    $imageType = $imageInfo[2];

    switch ($imageType) {
        case IMAGETYPE_JPEG:
            return imagecreatefromjpeg($url);
        case IMAGETYPE_PNG:
            return imagecreatefrompng($url);
        case IMAGETYPE_GIF:
            return imagecreatefromgif($url);
        default:
            return false;
    }
}

function addImageWithBorder($dest, $src, $destX, $destY, $srcW, $srcH, $borderColor, $borderWidth = 2) {
    if (!$src) {
        return;
    }

    $temp = imagecreatetruecolor($srcW + $borderWidth * 2, $srcH + $borderWidth * 2);
    $color = imagecolorallocate($temp, $borderColor[0], $borderColor[1], $borderColor[2]);
    imagefill($temp, 0, 0, $color);
    imagecopyresampled($temp, $src, $borderWidth, $borderWidth, 0, 0, $srcW, $srcH, imagesx($src), imagesy($src));
    imagecopy($dest, $temp, $destX, $destY, 0, 0, $srcW + $borderWidth * 2, $srcH + $borderWidth * 2);
    imagedestroy($temp);
}

function addTextWithBorder($image, $text, $fontPath, $fontSize, $textColor, $borderColor, $x, $y) {
    $borderOffsets = [-1, 0, 1];
    
    // Border color
    $borderColorAlloc = imagecolorallocate($image, $borderColor[0], $borderColor[1], $borderColor[2]);
    
    // Draw the border
    foreach ($borderOffsets as $dx) {
        foreach ($borderOffsets as $dy) {
            if ($dx !== 0 || $dy !== 0) {
                imagettftext($image, $fontSize, 0, $x + $dx, $y + $dy, $borderColorAlloc, $fontPath, $text);
            }
        }
    }
    
    // Text color
    $textColorAlloc = imagecolorallocate($image, $textColor[0], $textColor[1], $textColor[2]);
    
    // Draw the text
    imagettftext($image, $fontSize, 0, $x, $y, $textColorAlloc, $fontPath, $text);
}

// Get id from GET parameter
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Generate URLs based on the ID
$mainImageURL = "https://www.garsamba.com/trendresimler/{$id}-1.jpg"; // Ana resim URL'si
$overlayImageURLs = [
    "https://www.garsamba.com/trendresimler/{$id}-2.jpg",
    "https://www.garsamba.com/trendresimler/{$id}-3.jpg",
    "https://www.garsamba.com/trendresimler/{$id}-4.jpg"
];

$positions = [
    ['x' => 80, 'y' => 180],  // Position for first overlay image
    ['x' => 80, 'y' => 660], // Position for second overlay image
    ['x' => 80, 'y' => 1140]  // Position for third overlay image
];

$mainImage = createImageFromURL($mainImageURL);
if (!$mainImage) {
    die('Main image could not be loaded.');
}

$overlayImages = array_map('createImageFromURL', $overlayImageURLs);

$mainImageWidth = 1200;
$mainImageHeight = 1800;
$newImageWidth = 283;
$newImageHeight = 426;
$borderColor = [255, 255, 255]; // White color

$newImage = imagecreatetruecolor($mainImageWidth, $mainImageHeight);
imagecopyresampled($newImage, $mainImage, 0, 0, 0, 0, $mainImageWidth, $mainImageHeight, imagesx($mainImage), imagesy($mainImage));

foreach ($overlayImages as $index => $overlayImage) {
    $position = $positions[$index] ?? ['x' => 0, 'y' => 0]; // Default position if not set
    addImageWithBorder($newImage, $overlayImage, $position['x'], $position['y'], $newImageWidth, $newImageHeight, $borderColor);
}

/*veriçek*/
$db1 = new PDO("mysql:host=188.245.41.228;dbname=mihrunisa_site", 'mihrunisa_site', 'deneme8573041', array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"));

$query2 = $db1->query("SELECT * FROM oc_product_description where product_id = '$id'")->fetch(PDO::FETCH_ASSOC);
$baslik = $query2['name'];
$meta = $query2['tag'];
$meta = str_replace(" ","",$meta);
$meta = str_replace(","," #",$meta);
/*veriçek*/
/* sipecial fiyat */
$stmt2 = $db1->prepare("SELECT * FROM oc_product_special WHERE product_id = :product_id ");
$stmt2->execute(array(':product_id' => $id));
$result2 =  $stmt2->rowCount();
if($result2 > 0){
$query3x = $db1->query("SELECT * FROM oc_product_special WHERE product_id = '$id'")->fetch(PDO::FETCH_ASSOC);
$fiyat = $query3x['price'];	
$fiyat = number_format($fiyat, 0, '.', '');
}else{
$fiyat = $row['price'];
$fiyat = number_format($fiyat, 0, '.', '');
}
/* sipecial fiyat */

// Add text at the bottom center of the image, 100px from the bottom
$text = $fiyat."TL";
$fontPath = '../../fonts/font2.ttf'; // Path to the font file
$fontSize = 90; // Font size
$textColor = [255, 255, 255]; // White color for text
$offsetFromBottom = 100; // Offset from bottom
$textBorderColor = [255, 165, 0]; // Orange color for text border

// Calculate text box size
$bbox = imagettfbbox($fontSize, 0, $fontPath, $text);
$textWidth = abs($bbox[4] - $bbox[0]);
$textHeight = abs($bbox[5] - $bbox[1]);

// Get image dimensions
$imageWidth = imagesx($newImage);
$imageHeight = imagesy($newImage);

// Calculate x and y position to center the text and set distance from bottom
$x = ($imageWidth - $textWidth) / 2;
$y = $imageHeight - $textHeight - $offsetFromBottom + $fontSize;

addTextWithBorder($newImage, $text, $fontPath, $fontSize, $textColor, $textBorderColor, $x, $y);

header('Content-Type: image/png');
imagepng($newImage);
imagedestroy($newImage);
imagedestroy($mainImage);
foreach ($overlayImages as $overlayImage) {
    if ($overlayImage) {
        imagedestroy($overlayImage);
    }
}
?>
