<?php

function createImageFromURL($url) {
    $imageInfo = getimagesize($url);
    $imageType = $imageInfo[2];

    switch ($imageType) {
        case IMAGETYPE_JPEG:
            return imagecreatefromjpeg($url);
        case IMAGETYPE_PNG:
            return imagecreatefrompng($url);
        case IMAGETYPE_GIF:
            return imagecreatefromgif($url);
        default:
            return false;
    }
}

function addImageWithBorder($dest, $src, $destX, $destY, $srcW, $srcH, $borderColor, $borderWidth = 2) {
    $temp = imagecreatetruecolor($srcW + $borderWidth * 2, $srcH + $borderWidth * 2);
    $color = imagecolorallocate($temp, $borderColor[0], $borderColor[1], $borderColor[2]);
    imagefill($temp, 0, 0, $color);
    imagecopyresampled($temp, $src, $borderWidth, $borderWidth, 0, 0, $srcW, $srcH, imagesx($src), imagesy($src));
    imagecopy($dest, $temp, $destX, $destY, 0, 0, $srcW + $borderWidth * 2, $srcH + $borderWidth * 2);
    imagedestroy($temp);
}

function addTextToImage($image, $text, $fontPath, $fontSize, $color, $offsetFromBottom, $borderColor = null) {
    $textColor = imagecolorallocate($image, $color[0], $color[1], $color[2]);
    
    // Calculate text box size
    $bbox = imagettfbbox($fontSize, 0, $fontPath, $text);
    $textWidth = abs($bbox[4] - $bbox[0]);
    $textHeight = abs($bbox[5] - $bbox[1]);

    // Get image dimensions
    $imageWidth = imagesx($image);
    $imageHeight = imagesy($image);

    // Calculate x and y position to center the text and set distance from bottom
    $x = ($imageWidth - $textWidth) / 2;
    $y = $imageHeight - $textHeight - $offsetFromBottom;

    // Add border if border color is specified
    if ($borderColor) {
        $borderColorAllocate = imagecolorallocate($image, $borderColor[0], $borderColor[1], $borderColor[2]);
        for ($c1 = -1; $c1 <= 1; $c1++) {
            for ($c2 = -1; $c2 <= 1; $c2++) {
                imagettftext($image, $fontSize, 0, $x + $c1, $y + $c2, $borderColorAllocate, $fontPath, $text);
            }
        }
    }

    imagettftext($image, $fontSize, 0, $x, $y, $textColor, $fontPath, $text);
    return $y + $textHeight; // return y position of the bottom of the text
}

// Get id from GET parameter
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Generate URLs based on the ID
$mainImageURL = "https://www.garsamba.com/trendresimler/{$id}-1.jpg"; // Ana resim URL'si
$overlayImageURLs = [
    "https://www.garsamba.com/trendresimler/{$id}-2.jpg",
    "https://www.garsamba.com/trendresimler/{$id}-3.jpg",
    "https://www.garsamba.com/trendresimler/{$id}-4.jpg"
];

$positions = [
    ['x' => 80, 'y' => 180],  // Position for first overlay image
    ['x' => 80, 'y' => 660], // Position for second overlay image
    ['x' => 80, 'y' => 1140]  // Position for third overlay image
];

$mainImage = createImageFromURL($mainImageURL);
$overlayImages = array_map('createImageFromURL', $overlayImageURLs);

$mainImageWidth = 1200;
$mainImageHeight = 1800;
$newImageWidth = 283;
$newImageHeight = 426;
$borderColor = [255, 255, 255]; // White color

$newImage = imagecreatetruecolor($mainImageWidth, $mainImageHeight);
imagecopyresampled($newImage, $mainImage, 0, 0, 0, 0, $mainImageWidth, $mainImageHeight, imagesx($mainImage), imagesy($mainImage));

foreach ($overlayImages as $index => $overlayImage) {
    $position = $positions[$index];
    addImageWithBorder($newImage, $overlayImage, $position['x'], $position['y'], $newImageWidth, $newImageHeight, $borderColor);
}



// Add text at the bottom center of the image, 100px from the bottom
$mainText = "700TL";
$subText = "YETİŞEN ALIYOR";
$mainFontPath = '../../fonts/font2.ttf'; // Path to the main font file
$subFontPath = '../../fonts/font2.ttf'; // Path to the sub font file
$mainFontSize = 90; // Main text font size
$subFontSize = 30; // Sub text font size
$textColor = [255, 255, 255]; // White color for text
$borderTextColor = [255, 140, 0]; // Orange border color
$offsetFromBottom = 60; // Offset from bottom

$mainTextY = addTextToImage($newImage, $mainText, $mainFontPath, $mainFontSize, $textColor, $offsetFromBottom, $borderTextColor);
$subTextOffset = -170; // 15px below the main text
addTextToImage($newImage, $subText, $subFontPath, $subFontSize, $textColor, $mainImageHeight - $mainTextY - $subTextOffset - $subFontSize, $borderTextColor);

header('Content-Type: image/png');
imagepng($newImage);
imagedestroy($newImage);
imagedestroy($mainImage);
foreach ($overlayImages as $overlayImage) {
    imagedestroy($overlayImage);
}
?>
