<?php

function createImageFromURL($url) {
    $imageInfo = getimagesize($url);
    $imageType = $imageInfo[2];

    switch ($imageType) {
        case IMAGETYPE_JPEG:
            return imagecreatefromjpeg($url);
        case IMAGETYPE_PNG:
            return imagecreatefrompng($url);
        case IMAGETYPE_GIF:
            return imagecreatefromgif($url);
        default:
            return false;
    }
}

function addImageWithBorder($dest, $src, $destX, $destY, $srcW, $srcH, $borderColor, $borderWidth = 2) {
    $temp = imagecreatetruecolor($srcW + $borderWidth * 2, $srcH + $borderWidth * 2);
    $color = imagecolorallocate($temp, $borderColor[0], $borderColor[1], $borderColor[2]);
    imagefill($temp, 0, 0, $color);
    imagecopyresampled($temp, $src, $borderWidth, $borderWidth, 0, 0, $srcW, $srcH, imagesx($src), imagesy($src));
    imagecopy($dest, $temp, $destX, $destY, 0, 0, $srcW + $borderWidth * 2, $srcH + $borderWidth * 2);
    imagedestroy($temp);
}

function addTextToImage($image, $text, $fontPath, $fontSize, $color, $offsetFromBottom) {
    $textColor = imagecolorallocate($image, $color[0], $color[1], $color[2]);

    // Calculate text box size
    $bbox = imagettfbbox($fontSize, 0, $fontPath, $text);
    $textWidth = abs($bbox[4] - $bbox[0]);
    $textHeight = abs($bbox[5] - $bbox[1]);

    // Get image dimensions
    $imageWidth = imagesx($image);
    $imageHeight = imagesy($image);

    // Calculate x and y position to center the text and set distance from bottom
    $x = ($imageWidth - $textWidth) / 2;
    $y = $imageHeight - $textHeight - $offsetFromBottom;

    imagettftext($image, $fontSize, 0, $x, $y, $textColor, $fontPath, $text);
}

// Get id from GET parameter
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Generate URLs based on the ID
$mainImageURL = "https://www.garsamba.com/trendresimler/{$id}-1.jpg"; // Ana resim URL'si
$overlayImageURLs = [
    "https://www.garsamba.com/trendresimler/{$id}-2.jpg",
    "https://www.garsamba.com/trendresimler/{$id}-3.jpg",
    "https://www.garsamba.com/trendresimler/{$id}-4.jpg"
];

$positions = [
    ['x' => 80, 'y' => 180],  // Position for first overlay image
    ['x' => 80, 'y' => 660], // Position for second overlay image
    ['x' => 80, 'y' => 1140]  // Position for third overlay image
];

$mainImage = createImageFromURL($mainImageURL);
$overlayImages = array_map('createImageFromURL', $overlayImageURLs);

$mainImageWidth = 1200;
$mainImageHeight = 1800;
$newImageWidth = 283;
$newImageHeight = 426;
$borderColor = [255, 255, 255]; // White color

$newImage = imagecreatetruecolor($mainImageWidth, $mainImageHeight);
imagecopyresampled($newImage, $mainImage, 0, 0, 0, 0, $mainImageWidth, $mainImageHeight, imagesx($mainImage), imagesy($mainImage));

foreach ($overlayImages as $index => $overlayImage) {
    if ($overlayImage) { // Check if image was created successfully
        $position = $positions[$index];
        addImageWithBorder($newImage, $overlayImage, $position['x'], $position['y'], $newImageWidth, $newImageHeight, $borderColor);
    }
}

/*veriçek*/
$db1 = new PDO("mysql:host=188.245.41.228;dbname=mihrunisa_site", 'mihrunisa_site', 'deneme8573041', array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"));

$query2 = $db1->query("SELECT * FROM oc_product_description where product_id = '$id'")->fetch(PDO::FETCH_ASSOC);
$baslik = $query2['name'];
$meta = $query2['tag'];
$meta = str_replace(" ","",$meta);
$meta = str_replace(","," #",$meta);
/*veriçek*/

// Add text at the bottom center of the image, 100px from the bottom
$text = $baslik;
$fontPath = '../../fonts/font2.ttf'; // Path to the font file
$fontSize = 40; // Font size
$textColor = [255, 255, 255]; // White color for text
$offsetFromBottom = 80; // Offset from bottom

addTextToImage($newImage, $text, $fontPath, $fontSize, $textColor, $offsetFromBottom);

header('Content-Type: image/png');
imagepng($newImage);
imagedestroy($newImage);
imagedestroy($mainImage);
foreach ($overlayImages as $overlayImage) {
    if ($overlayImage) { // Check if image was created successfully
        imagedestroy($overlayImage);
    }
}
?>
