<?php
function createImageFromURL($url) {
    $imageInfo = getimagesize($url);
    $imageType = $imageInfo[2];

    switch ($imageType) {
        case IMAGETYPE_JPEG:
            return imagecreatefromjpeg($url);
        case IMAGETYPE_PNG:
            return imagecreatefrompng($url);
        case IMAGETYPE_GIF:
            return imagecreatefromgif($url);
        default:
            return false;
    }
}

function addImageWithBorder($dest, $src, $destX, $destY, $srcW, $srcH, $borderColor, $borderWidth = 2) {
    $temp = imagecreatetruecolor($srcW + $borderWidth * 2, $srcH + $borderWidth * 2);
    $color = imagecolorallocate($temp, $borderColor[0], $borderColor[1], $borderColor[2]);
    imagefill($temp, 0, 0, $color);
    imagecopyresampled($temp, $src, $borderWidth, $borderWidth, 0, 0, $srcW, $srcH, imagesx($src), imagesy($src));
    imagecopy($dest, $temp, $destX, $destY, 0, 0, $srcW + $borderWidth * 2, $srcH + $borderWidth * 2);
    imagedestroy($temp);
}

function addTextToImage($image, $text, $fontPath, $fontSize, $color, $offsetFromBottom) {
    $textColor = imagecolorallocate($image, $color[0], $color[1], $color[2]);

    // Calculate text box size
    $bbox = imagettfbbox($fontSize, 0, $fontPath, $text);
    $textWidth = abs($bbox[4] - $bbox[0]);
    $textHeight = abs($bbox[5] - $bbox[1]);

    // Get image dimensions
    $imageWidth = imagesx($image);
    $imageHeight = imagesy($image);

    // Calculate x and y position to center the text and set distance from bottom
    $x = ($imageWidth - $textWidth) / 2;
    $y = $imageHeight - $textHeight - $offsetFromBottom;

    imagettftext($image, $fontSize, 0, $x, $y, $textColor, $fontPath, $text);
}

// Get id from GET parameter
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Generate URLs manually
$mainImageURL = "https://www.garsamba.com/trendresimler/3693-1.jpg"; // Ana resim URL'si
$overlayImage1URL = "https://www.garsamba.com/trendresimler/3712-1.jpg"; // İlk overlay image URL'si
$overlayImage2URL = "https://www.garsamba.com/trendresimler/3692-1.jpg"; // İkinci overlay image URL'si
$overlayImage3URL = "https://www.garsamba.com/trendresimler/3691-1.jpg"; // Üçüncü overlay image URL'si
$overlayImage4URL = "https://www.garsamba.com/trendresimler/3690-1.jpg"; // Üçüncü overlay image URL'si

$positions = [
    ['x' => 80, 'y' => 100],  // Position for first overlay image
    ['x' => 80, 'y' => 500],  // Position for second overlay image
    ['x' => 80, 'y' => 900],  // Position for third overlay image
    ['x' => 80, 'y' => 1300]  // Position for third overlay image
];

$mainImage = createImageFromURL($mainImageURL);

// Manuel URL'lerden resim oluşturma
$overlayImage1 = createImageFromURL($overlayImage1URL);
$overlayImage2 = createImageFromURL($overlayImage2URL);
$overlayImage3 = createImageFromURL($overlayImage3URL);
$overlayImage4 = createImageFromURL($overlayImage4URL);

// Main image dimensions
$mainImageWidth = 1200;
$mainImageHeight = 1800;
$newImageWidth = 223;
$newImageHeight = 334;
$borderColor = [255, 255, 255]; // White color

$newImage = imagecreatetruecolor($mainImageWidth, $mainImageHeight);
imagecopyresampled($newImage, $mainImage, 0, 0, 0, 0, $mainImageWidth, $mainImageHeight, imagesx($mainImage), imagesy($mainImage));

// Add each overlay image manually
if ($overlayImage1) {
    addImageWithBorder($newImage, $overlayImage1, $positions[0]['x'], $positions[0]['y'], $newImageWidth, $newImageHeight, $borderColor);
}

if ($overlayImage2) {
    addImageWithBorder($newImage, $overlayImage2, $positions[1]['x'], $positions[1]['y'], $newImageWidth, $newImageHeight, $borderColor);
}

if ($overlayImage3) {
    addImageWithBorder($newImage, $overlayImage3, $positions[2]['x'], $positions[2]['y'], $newImageWidth, $newImageHeight, $borderColor);
}

if ($overlayImage4) {
    addImageWithBorder($newImage, $overlayImage4, $positions[3]['x'], $positions[3]['y'], $newImageWidth, $newImageHeight, $borderColor);
}

header('Content-Type: image/png');
imagepng($newImage);
imagedestroy($newImage);
imagedestroy($mainImage);

// Manuel olarak kullanılan resimlerin yok edilmesi
if ($overlayImage1) {
    imagedestroy($overlayImage1);
}

if ($overlayImage2) {
    imagedestroy($overlayImage2);
}

if ($overlayImage3) {
    imagedestroy($overlayImage3);
}
?>