<?php
function createImageFromURL($url) {
    $imageInfo = getimagesize($url);
    $imageType = $imageInfo[2];

    switch ($imageType) {
        case IMAGETYPE_JPEG:
            return imagecreatefromjpeg($url);
        case IMAGETYPE_PNG:
            return imagecreatefrompng($url);
        case IMAGETYPE_GIF:
            return imagecreatefromgif($url);
        default:
            return false;
    }
}

function addTextToImage($image, $text, $fontPath, $fontSize, $color, $x, $y, $borderColor = null) {
    $textColor = imagecolorallocate($image, $color[0], $color[1], $color[2]);
    
    // Calculate text box size
    $bbox = imagettfbbox($fontSize, 0, $fontPath, $text);
    $textWidth = abs($bbox[4] - $bbox[0]);
    $textHeight = abs($bbox[5] - $bbox[1]);

    // Add border if border color is specified
    if ($borderColor) {
        $borderColorAllocate = imagecolorallocate($image, $borderColor[0], $borderColor[1], $borderColor[2]);
        for ($c1 = -1; $c1 <= 1; $c1++) {
            for ($c2 = -1; $c2 <= 1; $c2++) {
                imagettftext($image, $fontSize, 0, $x + $c1, $y + $c2, $borderColorAllocate, $fontPath, $text);
            }
        }
    }

    imagettftext($image, $fontSize, 0, $x, $y, $textColor, $fontPath, $text);
}

// Get id from GET parameter
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

// Set up dimensions
$backgroundWidth = 1800;
$backgroundHeight = 1800;
$imageWidth = 1200;
$imageHeight = 1800;

// URLs for the background and overlay images
$backgroundURL = "https://garsamba.com/trendyol/cronapi/cronn/katalog-arka2.jpg"; // Replace with actual background image URL
$overlayURL = "https://www.garsamba.com/trendresimler/{$id}-1.jpg"; // Replace with actual overlay image URL

// Create images
$backgroundImage = createImageFromURL($backgroundURL);
$overlayImage = createImageFromURL($overlayURL);

// Create a new image
$newImage = imagecreatetruecolor($backgroundWidth, $backgroundHeight);
imagecopyresampled($newImage, $backgroundImage, 0, 0, 0, 0, $backgroundWidth, $backgroundHeight, imagesx($backgroundImage), imagesy($backgroundImage));

// Place the overlay image on the left
imagecopyresampled($newImage, $overlayImage, 0, 0, 0, 0, $imageWidth, $imageHeight, imagesx($overlayImage), imagesy($overlayImage));

// Add text to the right side
$text = "Ürün Kodu: AD-3645";
$fontPath = '../../fonts/font2.ttf'; // Path to the font file
$fontSize = 15; // Font size
$textColor = [255, 255, 255]; // White color for text
$borderTextColor = [255, 255, 255]; // Black border color

// Calculate the position for the text on the right side
$bbox = imagettfbbox($fontSize, 0, $fontPath, $text);
$textWidth = abs($bbox[4] - $bbox[0]);
$textHeight = abs($bbox[5] - $bbox[1]);

// 50px padding from the right edge, and 10px padding from the bottom
$textX = $backgroundWidth - $textWidth - 10;
$textY = $backgroundHeight - 10; // Position text slightly above the bottom edge

addTextToImage($newImage, $text, $fontPath, $fontSize, $textColor, $textX, $textY);

// Output the image
header('Content-Type: image/png');
header('Content-Disposition: filename="AD-3645"');
imagepng($newImage);
imagedestroy($newImage);
imagedestroy($backgroundImage);
imagedestroy($overlayImage);

?>
