<?php
include("../../ayarlar.php");
function createImageFromURL($url) {
    $imageInfo = getimagesize($url);
    $imageType = $imageInfo[2];

    switch ($imageType) {
        case IMAGETYPE_JPEG:
            return imagecreatefromjpeg($url);
        case IMAGETYPE_PNG:
            return imagecreatefrompng($url);
        case IMAGETYPE_GIF:
            return imagecreatefromgif($url);
        default:
            return false;
    }
}

function addTextToImage($image, $text, $fontPath, $fontSize, $color, $x, $y, $borderColor = null) {
    $textColor = imagecolorallocate($image, $color[0], $color[1], $color[2]);
    
    // Metin kutusu boyutunu hesapla
    $bbox = imagettfbbox($fontSize, 0, $fontPath, $text);
    $textWidth = abs($bbox[4] - $bbox[0]);
    $textHeight = abs($bbox[5] - $bbox[1]);

    // Kenarlık rengi belirtilmişse ekle
    if ($borderColor) {
        $borderColorAllocate = imagecolorallocate($image, $borderColor[0], $borderColor[1], $borderColor[2]);
        for ($c1 = -1; $c1 <= 1; $c1++) {
            for ($c2 = -1; $c2 <= 1; $c2++) {
                imagettftext($image, $fontSize, 0, $x + $c1, $y + $c2, $borderColorAllocate, $fontPath, $text);
            }
        }
    }

    imagettftext($image, $fontSize, 0, $x, $y, $textColor, $fontPath, $text);
}

$query1       = $db7->query("SELECT * FROM tsoft_Product where IsActive = 'true' and katalog = '0' ORDER BY id desc LIMIT 0,1")->fetch();
$ProductId  = $query1["ProductId"];
$ProductCode  = $query1["ProductCode"];
$ProductCode2 = str_replace("AD","MN",$ProductCode);



$query2 = $db2->query("SELECT * FROM oc_product WHERE model = '".$ProductCode2."'")->fetch();
$id  = $query2["product_id"];

if(!$query2){
echo "veri yok..";
exit;	
	
}


// GET parametresinden id'yi al
//$id = isset($_GET['id']) ? intval($_GET['id']) : 0;


// Boyutları ayarla
$backgroundWidth = 1800;
$backgroundHeight = 1800;
$imageWidth = 1200;
$imageHeight = 1800;


// Arka plan ve üst üste bindirme görüntüleri için URL'ler
$backgroundURL = "https://garsamba.com/trendyol/cronapi/cronn/katalog-arka.jpg";
$overlayURL = "https://www.garsamba.com/trendresimler/{$id}-1.jpg";
$outputDirectory2 = $_SERVER['DOCUMENT_ROOT'] . '/trendresimler/';
$outputFile2 = $outputDirectory2 . "{$id}-1.jpg";

if (!file_exists($outputFile2)) {
echo "resim yok <br>";
echo "$overlayURL - $ProductId - $ProductCode2 - $id<br>";
$update = $db7->exec("update tsoft_Product set katalog = '2' where ProductId = '".$ProductId."'");	
}



// Görüntüleri oluştur
$backgroundImage = createImageFromURL($backgroundURL);
$overlayImage = createImageFromURL($overlayURL);

// Yeni bir görüntü oluştur
$newImage = imagecreatetruecolor($backgroundWidth, $backgroundHeight);
imagecopyresampled($newImage, $backgroundImage, 0, 0, 0, 0, $backgroundWidth, $backgroundHeight, imagesx($backgroundImage), imagesy($backgroundImage));

// Üst üste bindirme görüntüsünü sola yerleştir
imagecopyresampled($newImage, $overlayImage, 0, 0, 0, 0, $imageWidth, $imageHeight, imagesx($overlayImage), imagesy($overlayImage));

// Sağ tarafa metin ekle
$text = $ProductCode;
$fontPath = '../../fonts/font2.ttf'; // Yazı tipi dosyasının yolu
$fontSize = 15; // Yazı tipi boyutu
$textColor = [255, 255, 255]; // Beyaz renk
$borderTextColor = [0, 0, 0]; // Siyah kenarlık rengi

// Sağ tarafta metin için pozisyonu hesapla
$bbox = imagettfbbox($fontSize, 0, $fontPath, $text);
$textWidth = abs($bbox[4] - $bbox[0]);
$textHeight = abs($bbox[5] - $bbox[1]);

// Sağ kenardan 10px, alttan 10px boşluk
$textX = $backgroundWidth - $textWidth - 10;
$textY = $backgroundHeight - 10; // Alt kenardan biraz yukarıda

addTextToImage($newImage, $text, $fontPath, $fontSize, $textColor, $textX, $textY);

// WebP formatında resmi belirtilen klasöre kaydet
$outputDirectory = $_SERVER['DOCUMENT_ROOT'] . '/katalogresim/'; // Mutlak yol kullanın
$outputFile = $outputDirectory . "{$ProductCode}.webp";

// Önceden kaydedilmiş bir dosya olup olmadığını kontrol et
if (file_exists($outputFile)) {
    echo "Dosya zaten mevcut: " . htmlspecialchars($outputFile);
	$update = $db7->exec("update tsoft_Product set katalog = '1' where ProductId = '".$ProductId."'");
} else {
    // WebP formatında resmi kaydet
    if (imagewebp($newImage, $outputFile, 90)) {
        echo "Resim başarıyla kaydedildi: " . htmlspecialchars($outputFile);
		$update = $db7->exec("update tsoft_Product set katalog = '1' where ProductId = '".$ProductId."'");
    } else {
        echo "Resim kaydedilirken bir hata oluştu.";
    }
}

// Kaydedilen dosyanın var olup olmadığını kontrol et
if (!file_exists($outputFile)) {
    echo "Dosya kaydedilemedi. Lütfen dizin izinlerini kontrol edin.";
}



imagedestroy($newImage);
imagedestroy($backgroundImage);
imagedestroy($overlayImage);


?>
