<?php
include('ayarlar.php');
include "../../../kutuphane/vendor-trendyol4/autoload.php";

use IS\PazarYeri\Trendyol\TrendyolClient;
use IS\PazarYeri\Trendyol\Helper\TrendyolException;

$trendyol = new TrendyolClient();
$trendyol->setSupplierId($supplier_id);
$trendyol->setUsername($api_username);
$trendyol->setPassword($api_password);

$sayfa = isset($_GET['page']) ? $_GET['page'] : 0;
$status = isset($_GET['status']) ? $_GET['status'] : "Created";

$iadeler = $trendyol->claim->claimList([
    'startDate'       => time() - (86400 * 14),
    'endDate'         => time(),
    'page'            => $sayfa,
    'size'            => 200,
    'claimItemStatus' => $status,
]);

foreach ($iadeler->content as $claim) {
    /* iade bilgiler */
    $claimId                = $claim->id;
    $orderNumber            = $claim->orderNumber;
	$orderDate              = $claim->orderDate;
    $customerFirstName      = $claim->customerFirstName;
    $customerLastName       = $claim->customerLastName;
	$claimDate              = $claim->claimDate;
    $cargoTrackingNumber    = $claim->cargoTrackingNumber;
    $cargoProviderName      = $claim->cargoProviderName;
    $cargoTrackingLink      = $claim->cargoTrackingLink;
    $orderShipmentPackageId = $claim->orderShipmentPackageId;
	$lastModifiedDate       = $claim->lastModifiedDate;
    $ClaimStatus            = $claim->items[0]->claimItems[0]->claimItemStatus->name;

    $orderDate = TarihCevir($orderDate);
    $claimDate = TarihCevir($claimDate);
    $lastModifiedDate = TarihCevir($lastModifiedDate);

    /* veri iade kayıt */
    $stmt = $db6->prepare("SELECT count(*) FROM trendyol_Claims_Order WHERE orderNumber = ?");
    $stmt->execute([$orderNumber]);
    $count = $stmt->fetchColumn();

    if (!$count) {
        $stmt = $db6->prepare("INSERT INTO trendyol_Claims_Order (
            claimId, orderNumber, orderDate, customerFirstName, customerLastName, claimDate,
            cargoTrackingNumber, cargoProviderName, cargoTrackingLink, orderShipmentPackageId, 
            lastModifiedDate, ClaimStatus
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $claimId, $orderNumber, $orderDate, $customerFirstName, $customerLastName, $claimDate,
            $cargoTrackingNumber, $cargoProviderName, $cargoTrackingLink, $orderShipmentPackageId, 
            $lastModifiedDate, $ClaimStatus
        ]);

        $stmtPush = $db6->prepare("INSERT INTO trendyol_Push (bildirim, pushId, tarih) VALUES ('Claim', ?, ?)");
        $stmtPush->execute([$orderNumber, $anlik_tarih]);

        echo "eklendi iade -> $claimDate - $orderNumber - $ClaimStatus<br>";
    } else {
        $stmt = $db6->prepare("UPDATE trendyol_Claims_Order SET 
            claimDate = ?, cargoTrackingNumber = ?, cargoProviderName = ?, cargoTrackingLink = ?, 
            orderShipmentPackageId = ?, lastModifiedDate = ?, ClaimStatus = ? 
            WHERE orderNumber = ?");
        $stmt->execute([
            $claimDate, $cargoTrackingNumber, $cargoProviderName, $cargoTrackingLink, 
            $orderShipmentPackageId, $lastModifiedDate, $ClaimStatus, $orderNumber
        ]);

        echo "güncellendi iade.. -> $claimDate - $orderNumber - $ClaimStatus<br>";
    }

    /* veri iade ürün kayıt */
    foreach ($claim->items as $item2) {
        $productName           = str_replace("'", "", $item2->orderLine->productName);
        $barcode               = $item2->orderLine->barcode;
        $price                 = $item2->orderLine->price;
        $ClaimItemStatus       = $item2->claimItems[0]->claimItemStatus->name;
        $ClaimItemsId          = $item2->claimItems[0]->id;
        $ClaimItemReasonName   = $item2->claimItems[0]->trendyolClaimItemReason->name;
        $ClaimItemReasonCode   = $item2->claimItems[0]->trendyolClaimItemReason->code;
        $uniquecode2           = $item2->claimItems[0]->orderLineItemId;

        $stmt = $db6->prepare("SELECT count(*) FROM trendyol_Claims_Order_Product WHERE uniquecode = ?");
        $stmt->execute([$uniquecode2]);
        $count = $stmt->fetchColumn();

        if (!$count) {
            $stmt = $db6->prepare("INSERT INTO trendyol_Claims_Order_Product (
                orderNumber, productName, barcode, price, ClaimItemsId, 
                ClaimItemReasonName, ClaimItemReasonCode, ClaimItemStatus, uniquecode
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([
                $orderNumber, $productName, $barcode, $price, $ClaimItemsId, 
                $ClaimItemReasonName, $ClaimItemReasonCode, $ClaimItemStatus, $uniquecode2
            ]);

            echo "eklendi iade ürün -> $productName<br>";
        } else {
            $stmt = $db6->prepare("UPDATE trendyol_Claims_Order_Product SET 
                ClaimItemsId = ?, ClaimItemReasonName = ?, ClaimItemReasonCode = ?, 
                ClaimItemStatus = ? WHERE uniquecode = ?");
            $stmt->execute([
                $ClaimItemsId, $ClaimItemReasonName, $ClaimItemReasonCode, 
                $ClaimItemStatus, $uniquecode2
            ]);

            echo "güncellendi iade ürün -> $productName<br>";
        }
    }
    /* veri iade ürün kayıt */
}
?>
