<?php
include('ayarlar.php');
require_once('../../../kutuphane/vendor-telegram/autoload.php');

// Telegram token ve chat ID'lerini ayarla
$telegramBots = [
    'telegram1' => ['token' => "1936812698:AAFxdeMCmi4HY52-y6MyJ8dt4sz5ZplqJN0", 'chat_id' => 1544830698],
    'telegram_iade' => ['token' => "5831675914:AAH1vrtwBrbP7Qk33zmjWgQTkFC8PkpmRWQ", 'chat_id' => 1544830698],
    'telegram_siparis' => ['token' => "5675599650:AAGFDHOBMzFaau7p2o9J9YgEiNBct6WizVI", 'chat_id' => 1544830698],
    'telegram_soru' => ['token' => "6149426966:AAGBQ1QzZg7Vs98xL1Pa0Qm-wouv86aFhRg", 'chat_id' => 1544830698],
    'telegram_bildirim' => ['token' => "6191633017:AAGRKN8soglUfrIvxn1KOXeYyrSIsYrNdCs", 'chat_id' => 1544830698],
];

$telegrams = [];
foreach ($telegramBots as $key => $bot) {
    $telegrams[$key] = new Telegram($bot['token']);
}

// Veri tabanından rastgele bir bildirim seç
$query1 = $db6->query("SELECT * FROM trendyol_Push where status != '1' order by rand() limit 0,1")->fetch(PDO::FETCH_ASSOC);

if (!$query1) {
    echo "veri yok";
} else {
    $bildirim = $query1['bildirim'];
    $pushId = $query1['pushId'];
    echo "$pushId - $bildirim<br>";

    if ($bildirim == "Questions") {
        processQuestions($pushId, $telegrams['telegram_soru'], $telegramBots['telegram_soru']['chat_id'], $db6);
    } elseif ($bildirim == "Claim") {
        processClaims($pushId, $telegrams['telegram_iade'], $telegramBots['telegram_iade']['chat_id'], $db6);
    } elseif ($bildirim == "Order") {
        processOrders($pushId, $telegrams['telegram_siparis'], $telegramBots['telegram_siparis']['chat_id'], $db6);
    }
}

// Soruları işle
function processQuestions($pushId, $telegram, $chatid, $db)
{
    $query = $db->query("SELECT * FROM trendyol_Questions where questionsId = '$pushId'")->fetch(PDO::FETCH_ASSOC);
    $productName = $query['productName'];
    $questionsText = $query['questionsText'];
    $webUrl = $query['webUrl'];
    $magaza = $query['magaza'];

    $mesaj = "1 adet soru var..\nMağaza: $magaza\nÜrün: $productName\nSoru: $questionsText";
    sendMessage($telegram, $mesaj, $pushId, $chatid, $db);
}

// İadeleri işle
function processClaims($pushId, $telegram, $chatid, $db)
{
    $query2 = $db->query("SELECT * FROM trendyol_Claims_Order where orderNumber = '$pushId'")->fetch(PDO::FETCH_ASSOC);
    $orderNumber = $query2['orderNumber'];
    $orderDate = formatDate($query2['orderDate']);
    $claimDate = formatDate($query2['claimDate']);

    $query3 = $db->query("SELECT barcode,ClaimItemReasonName FROM trendyol_Claims_Order_Product where orderNumber = '$orderNumber'")->fetch(PDO::FETCH_ASSOC);
    $barcode = $query3['barcode'];
    $sebep = $query3['ClaimItemReasonName'];

    $query4 = $db->query("SELECT productContentId FROM trendyol_Product where barcode = '$barcode'")->fetch(PDO::FETCH_ASSOC);
    $productContentId = $query4['productContentId'];

    $query5 = $db->query("SELECT * FROM trendyol_Orders where orderNumber = '$orderNumber'")->fetch(PDO::FETCH_ASSOC);
    $isim_soyisim = ucwords_tr($query5['fullName']);
    $teslim = formatDate($query5['deliveryDate']);

    $query6 = $db->query("SELECT * FROM trendyol_Orders_Product where orderNumber = '$orderNumber'")->fetch(PDO::FETCH_ASSOC);
    $productName = $query6['productName'];

    $webUrl = "https://www.trendyol.com/marka/urun-p-$productContentId";
    $mesaj = "1 adet iade var..\nÜrün: $productName\nSebep: $sebep\nLink: $webUrl";
    sendMessage($telegram, $mesaj, $pushId, $chatid, $db);
}

// Siparişleri işle
function processOrders($pushId, $telegram, $chatid, $db)
{
    $query2 = $db->query("SELECT * FROM trendyol_Orders where orderNumber = '$pushId'")->fetch(PDO::FETCH_ASSOC);
    $fullName = $query2['fullName'];

    $query3 = $db->query("SELECT * FROM trendyol_Orders_Product where orderNumber = '$pushId'")->fetch(PDO::FETCH_ASSOC);
    $productName = $query3['productName'];
    $barcode = $query3['barcode'];

    $query4 = $db->query("SELECT productContentId FROM trendyol_Product where barcode = '$barcode'")->fetch(PDO::FETCH_ASSOC);
    $productContentId = $query4['productContentId'];

    $webUrl = "https://www.trendyol.com/marka/urun-p-$productContentId";
    $mesaj = "1 adet sipariş var..\nMüşteri: $fullName\nÜrün: $productName\nLink: $webUrl";
    sendMessage($telegram, $mesaj, $pushId, $chatid, $db);
}

// Telegram mesajı gönder ve veritabanını güncelle
function sendMessage($telegram, $mesaj, $pushId, $chatid, $db)
{
    $content = ['chat_id' => $chatid, 'text' => $mesaj];
    $response = $telegram->sendMessage($content);

    if ($response['ok']) {
        $db->exec("update trendyol_Push set status = '1' where pushId = '$pushId'");
    } else {
        error_log('Telegram mesajı gönderilemedi: ' . print_r($response, true));
    }
}

// Tarihi biçimlendir
function formatDate($date)
{
    return date('d.m.Y H.i', strtotime('0 hours', strtotime($date)));
}

// Türkçe karakterleri büyük harfe çevir
/*
function ucwords_tr($text)
{
    $text = mb_convert_case($text, MB_CASE_TITLE, "UTF-8");
    return str_replace(
        ['i', 'ı', 'ç', 'ğ', 'ö', 'ş', 'ü'],
        ['İ', 'I', 'Ç', 'Ğ', 'Ö', 'Ş', 'Ü'],
        $text
    );
}
*/
?>
