

$(function() {
    NextPost.General();
    NextPost.Skeleton();
    NextPost.ContextMenu();
    NextPost.Tooltip();
    NextPost.Tabs();
    NextPost.Forms();

});


/**
 * NextPost Namespace
 */
var NextPost = {};
    
/**
 * General
 */
NextPost.General = function()
{   
    // Mobile menu
    $(".topbar-mobile-menu-icon").on("click", function() {
        $("body").toggleClass('mobile-menu-open');
    });


    // Pop State
    window.onpopstate = function(e){ 
        if(e.state) {
            window.location.reload(); 
        }
    }
}


/**
 * Main skeleton
 */
NextPost.Skeleton = function()
{
    if ($(".skeleton--full").length > 0) {
        var $elems = $(".skeleton--full").find(".skeleton-aside, .skeleton-content");
        $(window).on("resize", function() {
            var h = $(window).height() - $("#topbar").outerHeight();
            $elems.height(h);
        }).trigger("resize");

        $(".skeleton--full").show();
    }
}



/**
 * Context Menu
 */
NextPost.ContextMenu = function()
{
    $("body").on("click", ".context-menu-wrapper", function(event){
        var menu = $(this).find(".context-menu");

        $(".context-menu").not(menu).removeClass('active');
        menu.toggleClass("active");
        event.stopPropagation();
    });

    $(window).on("click", function() {
        $(".context-menu.active").removeClass("active");
    });

    $("body").on("click", ".context-menu", function(event) {
        event.stopPropagation();
    })
}

/**
 * ToolTips
 */
NextPost.Tooltip = function()
{
    $(".tippy").each(function() {
        var dom = $(this)[0];

        if ($(this).hasClass("js-tooltip-ready")) {
            var tip = $(this).data("tip");
            var popper = tip.getPopperElement(dom);

            tip.update(popper);
        } else {
            var tip = Tippy(dom);
            $(this).addClass("js-tooltip-ready");
            $(this).data("tip", tip);
        }
    });
}


/**
 * Tabs
 */
NextPost.Tabs = function()
{
    $("body").on("click", ".tabheads a", function() {
        var tab = $(this).data("tab");
        var $tabs = $(this).parents(".tabs");
        var $contents = $tabs.find(".tabcontents");
        var $content = $contents.find(">div[data-tab='"+tab+"']");

        if ($content.length != 1 || $(this).hasClass("active")) {
            return true;
        }

        $(this).parents(".tabheads").find("a").removeClass('active');
        $(this).addClass("active");

        $contents.find(">div").removeClass('active');
        $content.addClass('active');
    });
}


/**
 * General form functions
 */
NextPost.Forms = function()
{
    $("body").on("input focus", ":input", function() {
        $(this).removeClass("error");
    });

    $("body").on("change", ".fileinp", function(){
        if ($(this).val()) {
            var label = $(this).val().split('/').pop().split('\\').pop();
        } else {
            var label = $(this).data("label")
        }
        $(this).next("div").text(label).attr("title", label);
        $(this).removeClass('error');
    });

    NextPost.DatePicker();
    NextPost.Combobox();
    NextPost.AjaxForms();
}


/**
 * Date time pickers
 */
NextPost.DatePicker = function()
{
    $(".js-datepicker").each(function() {
        $(this).removeClass("js-datepicker");

        if ($(this).data("min-date")) {
            $(this).data("min-date", new Date($(this).data("min-date")))
        }

        if ($(this).data("start-date")) {
            $(this).data("start-date", new Date($(this).data("start-date")))
        }

        $(this).datepicker({
            language: $("html").attr("lang"),
            dateFormat: "yyyy-mm-dd",
            timeFormat: "hh:ii",
            autoClose: true,
            timepicker: true,
            toggleSelected: false
        });
    })
}