<?php
Class yurtici {
	
    protected static $_wsUserName, $_wsPassword, $_userLanguage, $_parameters, $_sclient;
    public $_debug = false;
    
    public function __construct(array $attributes = array()) {

        self::$_wsUserName = $attributes['wsUserName'];
        self::$_wsPassword = $attributes['wsPassword'];
        self::$_userLanguage = $attributes['userLanguage'];
        self::$_parameters = [

		'wsUserName'   => self::$_wsUserName,
		'wsPassword'   => self::$_wsPassword,
		'userLanguage' => self::$_userLanguage,
		];
    }
    
    public function setUrl($url) {
        self::$_sclient = new \SoapClient($url);
    }


 
    public function createShipment($datagelen) {
		
		$data = array_merge(
          array("wsUserName" => self::$_parameters['wsUserName'], 
                "wsPassword" => self::$_parameters['wsPassword'],
                "userLanguage" => self::$_parameters['userLanguage'],
          ),
          array("ShippingOrderVO" => $datagelen)
        );
		

        $this->setUrl('http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl');
        return self::$_sclient->createShipment($data);
    }
 
    public function cancelShipment($cargoKeys) {
		
		$data = array_merge(
          array("wsUserName" => self::$_parameters['wsUserName'], 
                "wsPassword" => self::$_parameters['wsPassword'],
                "userLanguage" => self::$_parameters['userLanguage'],
                "cargoKeys" => $cargoKeys,
          )
          
        );
		

        $this->setUrl('http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl');
        return self::$_sclient->cancelShipment($data);
    }
 
    public function queryShipment($keys,$keyType,$addHistoricalData=true,$onlyTracking=true) {
		
		$data = array_merge(
          array("wsUserName"        => self::$_parameters['wsUserName'], 
                "wsPassword"        => self::$_parameters['wsPassword'],
                "wsLanguage"        => self::$_parameters['userLanguage'],
                "keys"              => $keys,                                  // array olacak []
                "keyType"           => $keyType,                               // 0 – Kargo Anahtarı 1 – Fatura Anahtarı 
                "addHistoricalData" => $addHistoricalData,                     // true / false Default : false
                "onlyTracking"      => $onlyTracking,                          // true / false Default : false

          )
         
        );
		

        $this->setUrl('http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl');
        return self::$_sclient->queryShipment($data);
    }
	
	
    public function queryShipmentDetail($keys,$keyType,$addHistoricalData=true,$onlyTracking=true,$jsonData=true) {
		
		$data = array_merge(
          array("wsUserName"        => self::$_parameters['wsUserName'], 
                "wsPassword"        => self::$_parameters['wsPassword'],
                "wsLanguage"        => self::$_parameters['userLanguage'],
                "keys"              => $keys,                                  // array olacak []
                "keyType"           => $keyType,                               // 0 – Kargo Anahtarı 1 – Fatura Anahtarı 
                "addHistoricalData" => $addHistoricalData,                     // true / false Default : false
                "onlyTracking"      => $onlyTracking,                          // true / false Default : false
                "jsonData"          => $jsonData,                          // true / false Default : false

          )
         
        );
		

        $this->setUrl('http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl');
        return self::$_sclient->queryShipmentDetail($data);
    }
 
  
  
    public function __destruct() {
        if ($this->_debug) {
            print_r(self::$_parameters);
        }
    }   
}




$sifreler = array (

    "T1" => array(
         
		"bilgi"=>"GÖNDERİCİ ÖDEMELİ NORMAL GÖNDERİLER", 
		"kullaniciadi"=>"3080N387367040G",
		"sifre"=>"42k9xx8A1875C5M0",
		"talepno"=>"6829769",
		
		),
    "T2" => array(
         
		"bilgi"=>"GÖNDERİCİ ÖDEMELİ TAHSİLATLI TESLİMAT", 
		"kullaniciadi"=>"3080T387367040G",
		"sifre"=>"ux339p4i09U5AD0D",
		"talepno"=>"6829772",
		
		),
    "T3" => array(
         
		"bilgi"=>"ALICI ÖDEMELİ NORMAL GÖNDERİLER", 
		"kullaniciadi"=>"3080N387367040A",
		"sifre"=>"y4dyW660Ekd9N83r",
		"talepno"=>"6829768",
		
		),
    "T4" => array(
         
		"bilgi"=>"ALICI ÖDEMELİ TAHSİLATLI TESLİMAT", 
		"kullaniciadi"=>"3080T387367040A",
		"sifre"=>"Zb0b9KSC1DMWkP17",
		"talepno"=>"6829771",
		
		),
    );




     ?>