<?php
// Oturum parametrelerini ayarla
$session_lifetime = 86400 * 30; // 30 gün
ini_set('session.gc_maxlifetime', $session_lifetime); // Sunucu tarafında oturum ömrü
session_set_cookie_params($session_lifetime); // Tarayıcı tarafında oturum ömrü
session_start();

// Oturum süresini uzatmak için son kullanımı her sayfa yüklemesinde yenileyin
if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time']) > $session_lifetime) {
    // Eğer oturum süresi dolmuşsa oturumu sonlandırın
    session_unset();
    session_destroy();
} else {
    $_SESSION['login_time'] = time(); // Oturum süresini güncelle
}

// Giriş sayfasına yönlendirme
function redirect_if_logged_in() {
    if (isset($_SESSION['user_id']) || (isset($_COOKIE['user_id']) && isset($_COOKIE['username']))) {
        // Çerezler mevcutsa, oturum bilgilerini yükle
        if (!isset($_SESSION['user_id'])) {
            $_SESSION['user_id'] = $_COOKIE['user_id'];
            $_SESSION['username'] = $_COOKIE['username'];
            $_SESSION['login_time'] = time(); // Oturum süresini başlat
        }
        // Giriş yapmışsa ana sayfaya yönlendir
        header("Location: 1-ty-kargoya-verilmeyen-bekleyen2.php");
        exit;
    }
}

// Giriş yapılmışsa yönlendirme
redirect_if_logged_in();

if (isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    $remember = isset($_POST['remember']); // "Beni hatırla" seçeneği
    // Veritabanı bağlantısı
    try {
        $db6 = new PDO("mysql:host=188.245.41.228;dbname=garsamba_trendyol", 'garsamba_trendyol', 'nisa10022017', array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"));
        $db6->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $sql = "SELECT * FROM users WHERE username = :username";
        $stmt = $db6->prepare($sql);
        $stmt->bindParam(':username', $username);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Şifre kontrolü
            if (password_verify($password, $user['password'])) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['login_time'] = time();

                // "Beni hatırla" seçeneği seçildiyse çerez ayarla
                if ($remember) {
                    setcookie('user_id', $user['id'], time() + $session_lifetime, "/");
                    setcookie('username', $user['username'], time() + $session_lifetime, "/");
                    setcookie('login_time', time(), time() + $session_lifetime, "/");
                }

                header("Location: 1-ty-kargoya-verilmeyen-bekleyen2.php");
                exit;
            } else {
                $error = "Geçersiz şifre.";
            }
        } else {
            $error = "Bu kullanıcı adı bulunamadı.";
        }
    } catch (PDOException $e) {
        $error = "Bağlantı hatası: " . $e->getMessage();
    }
}

// Eğer giriş başarısız olduysa hata mesajı
if (isset($error)) {
    echo "<p style='color:red;'>$error</p>";
}
?>

<!DOCTYPE html>
<html lang="tr" class="body-full-height">
    <head>        
	<title>Giriş Yap - Garsamba</title>            
	        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <link rel="icon" href="favicon.ico" type="image/x-icon" />     
        <link rel="stylesheet" type="text/css" id="theme" href="/trendyol/css/theme-default.css?v=1686130652"/>
		<script type="text/javascript" src="js/plugins/jquery/jquery.min.js"></script>	<link rel="stylesheet" href="/trendyol/css/stil.css?v=1627936185">
	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.8.1/css/all.css" integrity="sha384-50oBUHEmvpQ+1lW4y57PTFmhCaXp0ML5d60M1M7uH2+nqUivzIebhndOJK28anvf" crossorigin="anonymous">
<style>
.beni_hatirla2 label {
	color:#fff!important;
	font-size:14px!important;
	
}
</style>
</head>	
    <body>
        
        <div class="login-container">
        
            <div class="login-box animated fadeInDown">
                <div class="login-logo"></div>
                <div class="login-body">
                    <div class="login-title"><strong>Hoşgeldin</strong>, <?php if(isset($error)) { echo $error; } ?></div>

<form action="" class="form-horizontal" method="post">
<div class="form-group">
	<div class="col-md-12">
		<input type="text" id="username" name="username" class="form-control" required/>
	</div>
</div>
<div class="form-group">
	<div class="col-md-12">
		<input type="password" id="password" name="password" class="form-control" required/>
	</div>
</div>
<div class="form-group">
	<div class="col-md-6 beni_hatirla2">
		<label class="check">
<input class="icheckbox beni_hatirla" type="checkbox" name="remember" id="remember" />
		Beni Hatırla</label>
	</div>
	<div class="col-md-6">
		<input class="btn btn-info btn-block" type="submit" value="GİRİŞ" name="login" id="login" />
	</div>
</div>
</form>
                </div>

            </div>
            
        </div>
   <?php include('alt.php'); ?>     
    </body>
</html>