<?php
function combineImages($imageUrl1, $imageUrl2, $outputWidth = 1800, $outputHeight = 1800) {
    // Resim 1'i yükle
    $image1 = imagecreatefromstring(file_get_contents($imageUrl1));
    if (!$image1) {
        die("Resim 1 yüklenemedi.");
    }
    $width1 = imagesx($image1);
    $height1 = imagesy($image1);

    // Resim 2'yi yükle
    $image2 = imagecreatefromstring(file_get_contents($imageUrl2));
    if (!$image2) {
        die("Resim 2 yüklenemedi.");
    }
    $width2 = imagesx($image2);
    $height2 = imagesy($image2);

    // Hedef genişlik ve yükseklik ayarları
    $targetWidth = $outputWidth;
    $targetHeight = $outputHeight;

    // Her bir resmin hedef genişliği
    $cropWidth = $targetWidth / 2;
    $cropHeight = $targetHeight;

    // Resim 1'i 1800x1800 boyutuna kırp
    $croppedImage1 = imagecrop($image1, ['x' => 0, 'y' => 0, 'width' => $cropWidth, 'height' => $cropHeight]);

    // Resim 2'yi 1800x1800 boyutuna kırp
    $croppedImage2 = imagecrop($image2, ['x' => $width2 - $cropWidth, 'y' => 0, 'width' => $cropWidth, 'height' => $cropHeight]);

    // Hedef resim oluştur
    $outputImage = imagecreatetruecolor($targetWidth, $targetHeight);

    // Resim 1'i hedef resme kopyala
    imagecopy($outputImage, $croppedImage1, 0, 0, 0, 0, $cropWidth, $cropHeight);

    // Resim 2'yi hedef resme kopyala
    imagecopy($outputImage, $croppedImage2, $cropWidth, 0, 0, 0, $cropWidth, $cropHeight);

    // Tarayıcıya resmi JPEG formatında gönder
    header('Content-Type: image/jpeg');
    imagejpeg($outputImage, null, 100); // 100 kalite parametresi en yüksek kaliteyi sağlar

    // Belleği boşalt
    imagedestroy($image1);
    imagedestroy($image2);
    imagedestroy($croppedImage1);
    imagedestroy($croppedImage2);
    imagedestroy($outputImage);
}

// Kullanım örneği
$imageUrl1 = "https://www.garsamba.com/trendresimler/3536-1.jpg";
$imageUrl2 = "https://www.garsamba.com/trendresimler/3536-3.jpg";

combineImages($imageUrl1, $imageUrl2);
?>

