<?php 
require_once "../ayarlar.php";


    // tsoft_Orders_Maliyet tablosundaki tüm verileri çek
	/*
    $query = "SELECT OrderCode, OrderTotalPrice, UrunMaliyet, KargoMaliyet, KomisyonMaliyet, Gider 
              FROM tsoft_Orders_Maliyet 
              WHERE OrderStatusId = 8";
			  */
    $query = "SELECT OrderCode, OrderTotalPrice, UrunMaliyet, KargoMaliyet, KomisyonMaliyet, Gider 
              FROM tsoft_Orders_Maliyet 
              WHERE OrderStatusId IN (8, 6, 1204)";
    $stmt = $db7->prepare($query);
    $stmt->execute();
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Her sipariş için kazancı hesapla ve güncelle
    foreach ($orders as $order) {
        $orderCode = $order['OrderCode'];
        $orderTotalPrice = $order['OrderTotalPrice'];
        $urunMaliyet = $order['UrunMaliyet'];
        $kargoMaliyet = $order['KargoMaliyet'];
        $komisyonMaliyet = $order['KomisyonMaliyet'];
        $gider = $order['Gider'];

        // Kazancı hesapla: OrderTotalPrice - (UrunMaliyet + KargoMaliyet + KomisyonMaliyet + Gider)
        $kazanc = $orderTotalPrice - ($urunMaliyet + $kargoMaliyet + $komisyonMaliyet + $gider);

        // Kazancı güncelle
        $updateQuery = "UPDATE tsoft_Orders_Maliyet SET Kazanc = :kazanc WHERE OrderCode = :orderCode";
        $updateStmt = $db7->prepare($updateQuery);
        $updateStmt->bindParam(':kazanc', $kazanc, PDO::PARAM_STR);
        $updateStmt->bindParam(':orderCode', $orderCode, PDO::PARAM_STR);
        $updateStmt->execute();
    }

    echo "Kazançlar başarıyla güncellendi.";

?>
