<?php
require_once "../ayarlar.php";

// Mevcut start değerini veritabanından alıyoruz
$row = $db7->query("SELECT last_start FROM sync_info WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
$current_start = $row['last_start'];

// API token'ını alıyoruz
$row4 = $db7->query("SELECT * FROM tsoft_token WHERE id = '1'")->fetch(PDO::FETCH_ASSOC);
$token = $row4['token'];

// API çağrısını yapıyoruz
$url = "http://www.alyadua.com/rest1/product/getProducts";
$fields = array(
    'token' => $token,
    'limit' => 50,
    'start' => $current_start
);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
curl_close($ch);

// JSON yanıtını kontrol ediyoruz
if ($response === false || empty($response)) {
    // Eğer yanıt alınamadıysa veya boşsa, start değerini sıfırlıyoruz
    $stmt = $db7->prepare("UPDATE sync_info SET last_start = 0 WHERE id = 1");
    $stmt->execute();
    echo "API'den veri alınamadı, start değeri sıfırlandı.";
    exit;
}

// JSON yanıtını işliyoruz
$batch_result = json_decode($response, true);

if (isset($batch_result['data']) && is_array($batch_result['data'])) {
    // Verileri işliyoruz
    foreach ($batch_result['data'] as $item) {
        $ProductId   = $item['ProductId'];
        $ProductCode = $item['ProductCode'];
        
        // Veritabanına kayıt işlemleri
        $stmt = $db7->prepare("SELECT count(*) FROM tsoft_Product_New WHERE ProductId = ?");
        $stmt->execute([$ProductId]);
        $count = $stmt->fetchColumn();
        if (!$count) {
            $query = $db7->prepare("INSERT INTO tsoft_Product_New (ProductId, ProductCode) VALUES (?, ?)");
            $query->execute([$ProductId, $ProductCode]);
            echo "Ürün eklendi -> $ProductId - $ProductCode<br>";
        } else {
            echo "Ürün güncellendi -> $ProductId - $ProductCode<br>";
        }
    }

    // `start` değerini güncelliyoruz
    $new_start = $current_start + 50; // limit değerini ekliyoruz
    $stmt = $db7->prepare("UPDATE sync_info SET last_start = ? WHERE id = 1");
    $stmt->execute([$new_start]);

    echo "Veriler güncellendi ve yeni start değeri veritabanına kaydedildi.";
} else {
    // Eğer veri yoksa, start değerini sıfırlıyoruz
    $stmt = $db7->prepare("UPDATE sync_info SET last_start = 0 WHERE id = 1");
    $stmt->execute();
    echo "Veri bulunamadı, start değeri sıfırlandı.";
}
?>
