<?php 
require_once "ayarlar.php";

    // Şehirleri sayan SQL sorgusu: Türkiye için şehirleri gruplandır
    $sql_city = "SELECT CustomerCity, COUNT(*) as city_count 
                 FROM tsoft_Order_Bilgi 
                 WHERE CustomerCountry = 'Türkiye'
                 GROUP BY CustomerCity 
                 ORDER BY city_count DESC";
    
    // Ülkeleri sayan SQL sorgusu: tüm ülkeleri gruplandır
    $sql_country = "SELECT CustomerCountry, COUNT(*) as country_count 
                    FROM tsoft_Order_Bilgi 
                    GROUP BY CustomerCountry 
                    ORDER BY country_count DESC";

    // Şehirler için sorguyu çalıştırma
    $stmt_city = $db7->prepare($sql_city);
    $stmt_city->execute();
    $results_city = $stmt_city->fetchAll(PDO::FETCH_ASSOC);

    // Ülkeler için sorguyu çalıştırma
    $stmt_country = $db7->prepare($sql_country);
    $stmt_country->execute();
    $results_country = $stmt_country->fetchAll(PDO::FETCH_ASSOC);

    // Türkiye'deki şehirleri ekrana yazdırma
    if ($results_city) {
        echo "<h3>Türkiye'deki Şehirler ve Sipariş Sayıları</h3>";
        echo "<table border='1'>";
        echo "<tr><th>Şehir</th><th>Sipariş Sayısı</th></tr>";
        foreach ($results_city as $row_city) {
            echo "<tr><td>" . htmlspecialchars($row_city['CustomerCity']) . "</td><td>" . $row_city['city_count'] . "</td></tr>";
        }
        echo "</table>";
    } else {
        echo "Türkiye'den sipariş bulunamadı.";
    }

    // Tüm ülkeleri ekrana yazdırma
    if ($results_country) {
        echo "<h3>Ülkeler ve Sipariş Sayıları</h3>";
        echo "<table border='1'>";
        echo "<tr><th>Ülke</th><th>Sipariş Sayısı</th></tr>";
        foreach ($results_country as $row_country) {
            echo "<tr><td>" . htmlspecialchars($row_country['CustomerCountry']) . "</td><td>" . $row_country['country_count'] . "</td></tr>";
        }
        echo "</table>";
    } else {
        echo "Sipariş veren ülke bulunamadı.";
    }


?>
