<?php
Class yurtici {
	
    protected static $_wsUserName, $_wsPassword, $_userLanguage, $_parameters, $_sclient;
    public $_debug = false;
    
    public function __construct(array $attributes = array()) {

        self::$_wsUserName = $attributes['wsUserName'];
        self::$_wsPassword = $attributes['wsPassword'];
        self::$_userLanguage = $attributes['userLanguage'];
        self::$_parameters = [

		'wsUserName'   => self::$_wsUserName,
		'wsPassword'   => self::$_wsPassword,
		'userLanguage' => self::$_userLanguage,
		];
    }
    
    public function setUrl($url) {
        self::$_sclient = new \SoapClient($url);
    }


 
    public function createShipment($datagelen) {
		
		$data = array_merge(
          array("wsUserName" => self::$_parameters['wsUserName'], 
                "wsPassword" => self::$_parameters['wsPassword'],
                "userLanguage" => self::$_parameters['userLanguage'],
          ),
          array("ShippingOrderVO" => $datagelen)
        );
		

        $this->setUrl('http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl');
        return self::$_sclient->createShipment($data);
    }
 
    public function cancelShipment($cargoKeys) {
		
		$data = array_merge(
          array("wsUserName" => self::$_parameters['wsUserName'], 
                "wsPassword" => self::$_parameters['wsPassword'],
                "userLanguage" => self::$_parameters['userLanguage'],
                "cargoKeys" => $cargoKeys,
          )
          
        );
		

        $this->setUrl('http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl');
        return self::$_sclient->cancelShipment($data);
    }
 
    public function queryShipment($keys,$keyType,$addHistoricalData=true,$onlyTracking=true) {
		
		$data = array_merge(
          array("wsUserName"        => self::$_parameters['wsUserName'], 
                "wsPassword"        => self::$_parameters['wsPassword'],
                "wsLanguage"        => self::$_parameters['userLanguage'],
                "keys"              => $keys,                                  // array olacak []
                "keyType"           => $keyType,                               // 0 – Kargo Anahtarı 1 – Fatura Anahtarı 
                "addHistoricalData" => $addHistoricalData,                     // true / false Default : false
                "onlyTracking"      => $onlyTracking,                          // true / false Default : false

          )
         
        );
		

        $this->setUrl('http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl');
        return self::$_sclient->queryShipment($data);
    }
	
	
    public function queryShipmentDetail($keys,$keyType,$addHistoricalData=true,$onlyTracking=true,$jsonData=true) {
		
		$data = array_merge(
          array("wsUserName"        => self::$_parameters['wsUserName'], 
                "wsPassword"        => self::$_parameters['wsPassword'],
                "wsLanguage"        => self::$_parameters['userLanguage'],
                "keys"              => $keys,                                  // array olacak []
                "keyType"           => $keyType,                               // 0 – Kargo Anahtarı 1 – Fatura Anahtarı 
                "addHistoricalData" => $addHistoricalData,                     // true / false Default : false
                "onlyTracking"      => $onlyTracking,                          // true / false Default : false
                "jsonData"          => $jsonData,                          // true / false Default : false

          )
         
        );
		

        $this->setUrl('http://webservices.yurticikargo.com:8080/KOPSWebServices/ShippingOrderDispatcherServices?wsdl');
        return self::$_sclient->queryShipmentDetail($data);
    }
 
  
  
    public function __destruct() {
        if ($this->_debug) {
            print_r(self::$_parameters);
        }
    }   
}




$sifreler = array (

    "T1" => array(
         
		"bilgi"=>"GÖNDERİCİ ÖDEMELİ NORMAL GÖNDERİLER", 
		"kullaniciadi"=>"3084G1127313119",
		"sifre"=>"55CY04x7GiJ3HvV6",
		
		),
    "T2" => array(
         
		"bilgi"=>"GÖNDERİCİ ÖDEMELİ TAHSİLATLI TESLİMAT", 
		"kullaniciadi"=>"3084T1127313119",
		"sifre"=>"VM601U2V2ppbB85i",
		
		),
    "T3" => array(
         
		"bilgi"=>"ALICI ÖDEMELİ NORMAL GÖNDERİLER", 
		"kullaniciadi"=>"3084A1127313119",
		"sifre"=>"2R2J3R7VX6eXDERH",
		
		),
    "T4" => array(
         
		"bilgi"=>"ALICI ÖDEMELİ TAHSİLATLI TESLİMAT", 
		"kullaniciadi"=>"3084Y1127313119",
		"sifre"=>"C6z532M862501mMb",
		
		),
    );




     ?>